#ifndef __CCriticalSection__
#define __CCriticalSection__

#include "../Basics/CCountedObject.hpp"
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace Threading
	{
		/**
		 * @class CCriticalSection CCriticalSection.hpp
		 * @brief A wrapper around a cross platform critical section
		 *
		 * @date 07/08/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CCriticalSection.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CCriticalSection : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 */
			CCriticalSection();

			/**
			 * Destruction
			 */
			virtual ~CCriticalSection();

//	===========================================================================

			/**
			 * Try to enter a critical section, with a specified wait time
			 * @param spinTimeInMilliseconds Amount of time to wait between checks to enter critical section
			 * @retval bool True if entered correctly, false otherwise
			 */
			bool tryToEnterCriticalSection(const long spinTimeInMilliseconds) const;

			/**
			 * Enter the critical section
			 */
			void enterCriticalSection(void) const;

			/**
			 * Leave a critical section
			 */
    		void leaveCriticalSection(void) const;

//	===========================================================================

		protected:

//	===========================================================================

			#ifdef WIN32
				CRITICAL_SECTION *m_criticalSection;				/**< The ciritical section */
			#else
				MPCriticalRegionID m_criticalSection;				/**< The ciritical section */
			#endif
		};
	}
}

#endif